using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace MojaPierwszaGraXNA
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        //private BasicEffect efekt = null;
        Effect efekt = null;
        Matrix World = Matrix.Identity, ViewProjection;
        
        Kwadryka scietyStozek, walec, stozek, dysk, kolo, sfera;

        /*
        //MessageBox via PInvoke
        [System.Runtime.InteropServices.DllImport("user32.dll", CharSet = System.Runtime.InteropServices.CharSet.Auto)]
        public static extern uint MessageBox(IntPtr hWnd, String text, String caption, uint type);            
        */

        public Game1()
        {
            Window.Title = "Modul 2. Owietlenie: Laboratorium rozszerzone";
            //Window.AllowUserResizing = true;

            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            scietyStozek = Kwadryka.StworzScietyStozek(graphics.GraphicsDevice, 0.75f, 0.5f, 1.0f, 100, Color.White);
            walec = Kwadryka.StworzWalec(graphics.GraphicsDevice, 0.5f, 1.0f, 1000, Color.White);
            stozek = Kwadryka.StworzStozek(graphics.GraphicsDevice, 0.75f, 1.0f, 100, Color.White);
            dysk = Kwadryka.StworzDysk(graphics.GraphicsDevice, 0.25f, 0.75f, 100, Color.White);
            kolo = Kwadryka.StworzKolo(graphics.GraphicsDevice, 1, 100, Color.White);
            sfera = Kwadryka.StworzSfere(graphics.GraphicsDevice, 0.75f, 100, 100, Color.White);            

            //efekt                        
            //efekt = new BasicEffect(graphics.GraphicsDevice);
            //efekt.VertexColorEnabled = false;

            //oswietlenie domyslne
            /*
            efekt.EnableDefaultLighting();
            efekt.DirectionalLight1.DiffuseColor = Color.Black.ToVector3();
            efekt.DirectionalLight1.SpecularColor = Color.Black.ToVector3();
            efekt.DirectionalLight2.DiffuseColor = Color.Black.ToVector3();
            efekt.DirectionalLight2.SpecularColor = Color.Black.ToVector3();
            */

            //odwieanie ustawie sceny            
            //this.TargetElapsedTime = TimeSpan.FromMilliseconds(13.333f);
            //this.TargetElapsedTime = TimeSpan.FromSeconds(1.0f/75.0f);
            this.IsFixedTimeStep = false;
            
            //pelny ekran
            /*
            try
            {                
                //graphics.PreferredBackBufferWidth = 800;
                //graphics.PreferredBackBufferHeight = 600;
                graphics.PreferredBackBufferWidth = graphics.GraphicsDevice.DisplayMode.Width;
                graphics.PreferredBackBufferHeight = graphics.GraphicsDevice.DisplayMode.Height;
                graphics.IsFullScreen = true; //tylko w Windows  
                graphics.ApplyChanges();
                //alternatywnie:
                //graphics.ToggleFullScreen(); //tylko w Windows  
            }
            catch (Exception exc)
            {
                MessageBox(new IntPtr(0), "Bd podczas przeczania w tryb penoekranowy:\n"+exc.Message, Window.Title, 16);
            }            
            */

            //macierz rzutowania                        
            //efekt.Projection = Matrix.CreateOrthographic(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 0.0f, 100.0f);
            ////efekt.Projection = Matrix.CreatePerspective(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 1.0f, 100.0f);

            //kamera
            ////efekt.View = Matrix.CreateTranslation(0, 0, -1);
            //efekt.View = Matrix.CreateLookAt(new Vector3(0, 0, 2), new Vector3(0, 0, 0), new Vector3(0, 1, 0));

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            //Wczytywanie efektu
            efekt = Content.Load<Effect>("efekt");

            efekt.Parameters["OswietleniePerPixel"].SetValue(true);
            efekt.Parameters["PozycjaZrodlaSwiatla"].SetValue(new Vector3(1, 1, 1));
            efekt.Parameters["PolozenieKamery"].SetValue(new Vector3(0, 0, 1));

            efekt.Parameters["Ca"].SetValue(new Vector4(0.5f,0.5f,0.5f,1));
            efekt.Parameters["Cd"].SetValue(new Vector4(0.75f,0.75f,0.75f,1));
            efekt.Parameters["Cd"].SetValue(new Vector4(1,1,1,1));


            World = Matrix.CreateRotationX(-MathHelper.PiOver2);
            ViewProjection =
                Matrix.CreateLookAt(new Vector3(0, 0, 2), new Vector3(0, 0, 0), new Vector3(0, 1, 0)) *
                Matrix.CreateOrthographic(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 0.0f, 100.0f);                
            efekt.Parameters["WVP"].SetValue(World * ViewProjection);
            efekt.Parameters["World"].SetValue(World);

            efekt.Parameters["Tekstura"].SetValue(this.Content.Load<Texture2D>("tekstura"));
            efekt.Parameters["MapaNormalnych"].SetValue(this.Content.Load<Texture2D>("mapa_normalnych"));
            efekt.Parameters["MapaRozblysku"].SetValue(this.Content.Load<Texture2D>("mapa_rozblysku"));

            //efekt.Texture = this.Content.Load<Texture2D>("Ziemia");
            //efekt.TextureEnabled = true;
            //dla walca
            //efekt.World = Matrix.CreateRotationX(-MathHelper.PiOver2) * Matrix.CreateTranslation(0, -0.5f, 0);
            //dla sfery
            //efekt.World = Matrix.CreateRotationX(-MathHelper.PiOver2);
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            //klawiatura
            if (Keyboard.GetState().IsKeyDown(Keys.Escape)) this.Exit();
            if (Keyboard.GetState().IsKeyDown(Keys.Space)) graphics.ToggleFullScreen();            

            //ruch kamery (obrot wokol osi OY)
            /*
            efekt.View *=
                Matrix.CreateTranslation(0, 0, 2) *
                //Matrix.CreateRotationX(gameTime.ElapsedRealTime.Milliseconds / 3000.0f) *
                Matrix.CreateRotationY(gameTime.ElapsedRealTime.Milliseconds / 3000.0f) *
                Matrix.CreateTranslation(0, 0, -2);
            */

            if (Keyboard.GetState().IsKeyDown(Keys.Up)) World *= Matrix.CreateRotationX(-0.01f);
            if (Keyboard.GetState().IsKeyDown(Keys.Down)) World *= Matrix.CreateRotationX(0.01f);

            World *= Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 3000.0f);

            efekt.Parameters["WVP"].SetValue(World * ViewProjection);
            efekt.Parameters["World"].SetValue(World);
            
            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            //graphics.GraphicsDevice.Clear(Color.CornflowerBlue);            

            // TODO: Add your drawing code here                    
            GraphicsDevice gd = graphics.GraphicsDevice;
            gd.Clear(Color.Black);
            //gd.RenderState.CullMode = CullMode.CullCounterClockwiseFace;
            gd.RasterizerState = RasterizerState.CullNone;

            foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
            {
                pass.Apply();

                //gd.Vertices[0].SetSource(walec.BuforWerteksow, 0, VertexPositionColorNormal.SizeInBytes);
                //gd.DrawPrimitives(PrimitiveType.PointList, 0, walec.IloscPasm * walec.IloscTrojkatowWPasmie);
                //gd.DrawPrimitives(PrimitiveType.TriangleStrip, 0, walec.IloscTrojkatowWPasmie);

                //gd.Vertices[0].SetSource(sfera.BuforWerteksow, 0, VertexPositionColorNormal.SizeInBytes);
                //gd.DrawPrimitives(PrimitiveType.PointList, 0, sfera.IloscPasm * sfera.IloscTrojkatowWPasmie);
                //for(int i=0;i<sfera.IloscPasm;i++) gd.DrawPrimitives(PrimitiveType.TriangleStrip, i*sfera.IloscTrojkatowWPasmie, walec.IloscTrojkatowWPasmie);
            }

            /*
            stozekSciety.Rysuj(efekt);
            walec.Rysuj(efekt);
            stozek.Rysuj(efekt);
            dysk.Rysuj(efekt);
            sfera.Rysuj(efekt);
            */

            //walec.Rysuj(efekt);
            sfera.Rysuj(efekt);

            base.Draw(gameTime);
        }
    }
}
